var Popup = (function () {

	// Local variables
	// s == settings
	var s = {},
		isExitPopupShown = false,
		previousY = 0,
		isPopupVisible = false;

	// Show popup every...
	var setCookie = function() {
		Cookies.set('popup-shown', 'true', {
			expires: 3
		});
	};

	var close = function() {
		s.popupOverlayEl.addClass('visuallyhidden');
		s.popupEl.addClass('visuallyhidden');

		isPopupVisible = false;
	};

	var show = function() {
		// If another popup is already visible - don't show the next one
		if (!isPopupVisible) {
			s.popupOverlayEl.removeClass('visuallyhidden');

			// Show the popup
			s.popupEl.removeClass('visuallyhidden');

			isPopupVisible = true;
			setCookie();
		}
	};

	var init = function(config) {
		s = config;

		// Handle popup close events

		// On outside popup click
		s.popupOverlayEl.on('click', close);

		// On "x" click
		s.closeEl.on('click', close);

		// But do nothing when clicked inside popup
		s.popupEl.on('click', function (e) {
			e.stopPropagation();
		});

		// Autoshow popup after x seconds
		if (!Cookies.get('popup-shown')) {

			// Show 1st time - autoshow
			window.setTimeout(function () {
				show();
			}, 5000);

			// Show 2nd time - on exit
			$(document).on('mousemove', function (e) {
				if (e.pageY - $(document).scrollTop() <= 20 && previousY > e.pageY && !isExitPopupShown) {
					show();
					isExitPopupShown = true;
				}

				previousY = e.pageY;
			});
		}
	};

	return {
		init: init
	};

})();